@extends('layouts.invoice')

@section('content')
<section>
	<div class="card elevation-0 mb-0">
		<div class="card-body p-0">
			<div class="row">
				<div class="col-12">
					<div class="table-responsive">
						<table class="table table-bordered table-striped mb-0">
							<thead>
								<tr>
									<th class="nowrap">{{ __('reports.th_reg_no') }}</th>
									<th>{{ __('reports.th_member_name') }}</th>
									<th>{{ __('reports.th_phone') }}</th>
									<th class="nowrap">{{ __('reports.th_membership_type') }}</th>
									<th class="nowrap">{{ __('reports.th_valid_from') }}</th>
									<th class="nowrap">{{ __('reports.th_valid_to') }}</th>
									<th class="nowrap fixed-width-td">{{ __('reports.th_status') }}</th>
								</tr>
							</thead>
							<tbody>
								@foreach($members as $member)
								<tr>
									<td class="align-middle">{{ $member->reg_no }}</td>
									<td class="align-middle nowrap">{{ $member->name }}</td>
									<td class="align-middle">{{ $member->phone }}</td>
									<td class="align-middle nowrap">{{ $member->membership_name }}</td>
									<td class="align-middle nowrap">{{ format_date($member->valid_from) }}</td>
									<td class="align-middle nowrap">{{ format_date($member->valid_to) }}</td>
									<td class="align-middle nowrap">{!! membership_status_text($member->valid_to) !!}
									</td>
								</tr>
								@endforeach

								@if(count($members) == 0)
								<tr>
									<td colspan="11">
										<p class="text-center text-muted mb-0">No Record Found</p>
									</td>
								</tr>
								@endif
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
@endsection

@section('js-script')
<script>
	window.addEventListener("load", window.print());
</script>
@endsection